<?php
require "config.php";
include "nav.php";

	if (!isset($_COOKIE['id'])) {
		header("Location: reglog.php");
		exit;
	}

	$felhasznalo_id = (int)$_COOKIE['id'];

	$rendezveny_id = isset($_GET['rendezveny_id']) ? (int)$_GET['rendezveny_id'] : 0;
	if ($rendezveny_id <= 0) {
		echo "<p>Hibás vagy hiányzó rendezvény azonosító.</p>";
		exit;
	}

	$adat = $conn->query("SELECT * FROM events WHERE id=$rendezveny_id AND user_id=$felhasznalo_id");
	if (!$adat || $adat->num_rows === 0) {
		echo "<p>Nincs jogosultság ehhez a rendezvényhez.</p>";
		exit;
	}
	$rendezveny = $adat->fetch_assoc();

// Jegy hozzáadása
	$uzenet = "";
	if (isset($_POST['nev'], $_POST['ar'], $_POST['darabszam'])) {
		$nev       = $_POST['nev'];
		$ar        = (int)$_POST['ar'];
		$darabszam = (int)$_POST['darabszam'];

	if ($nev != "" && $ar > 0 && $darabszam >= 0) {
		$conn->query("
			INSERT INTO tickets (event_id, name, price, quantity)
			VALUES ($rendezveny_id, '$nev', $ar, $darabszam)
		");
		$uzenet = "Jegy sikeresen hozzáadva.";
	}
}

	$jegyek = [];
	$talalat = $conn->query("SELECT * FROM tickets WHERE event_id=$rendezveny_id ORDER BY price");
	if ($talalat && $talalat->num_rows > 0) {
	while ($sor = $talalat->fetch_assoc()) {
		$jegyek[] = $sor;
	}
}
?>
	<!DOCTYPE html>
	<html lang="hu">
	<head>
	<meta charset="UTF-8">
	<title>Jegyek kezelése</title>
	<link rel="stylesheet" href="css/styles.css">
</head>
<body>

	<h1>Jegyek kezelése – <?= $rendezveny['title'] ?></h1>

	<?php if ($uzenet): ?>
	<div class="alert success"><?= $uzenet ?></div>
	<?php endif; ?>

	<form method="post" class="form row">
		<label>Név
			<input type="text" name="nev" placeholder="Early Bird" required>
		</label>
		<label>Ár (Ft)
			<input type="number" name="ar" min="0" required>
		</label>
		<label>Darabszám
			<input type="number" name="darabszam" min="0" required>
		</label>
		<button class="btn-primary" type="submit">Hozzáadás</button>
	</form>

<h2>Meglévő jegyek</h2>

	<table class="table">
		<thead>
			<tr>
				<th>Név</th>
				<th>Ár</th>
				<th>Készlet</th>
			</tr>
		</thead>
		<tbody>
			<?php foreach ($jegyek as $j): ?>
			<tr>
				<td><?= $j['name'] ?></td>
				<td><?= number_format($j['price'], 0, ',', ' ') ?> Ft</td>
				<td><?= $j['quantity'] ?></td>
			</tr>
			<?php endforeach; ?>
		</tbody>
	</table>

</body>
</html>
